
;;-------------		Timer0 Definitionen		---------------------
;T0PS_Maske		EQU		0xF8		; b'1111.1000,zum clear des prescalar bit
;; T0-flag Bit definitionen 
T0_OVF		EQU	H'0000'	; Timer 0 Overflow bit,in IRQ=LOW gesetzt 	
Pause		EQU	H'0001'	; Pause zustandsbit
T0_Mode		EQU	H'0002'	; 0=Diagnose Mode, 1= Delay Mode
Flasher		EQU	H'0003'	; Prescal bit0
PS0_Temp	EQU	H'0004'	; Prescal bit0
PS1_Temp	EQU	H'0005'	; Prescal bit1
PS2_Temp	EQU	H'0006'	; Prescal bit1
T0_Temp		EQU	H'0007'	; Temporer

;----------	LCD Difinitionen	-------------------------
LCD_ScreenWith	EQU		0x10	;16 zeichen	
LCD_DDRAM_With	EQU		0x50	; DDRAM With, 80 Speicherzellen

ClearDisplay	EQU  b'00000001'	; b:0
ReturnHome		EQU  b'00000010'	; b:1
SetMode			EQU  b'00000111'	;Cursor nach link, display shift An
DCB_ON			EQU  b'00001111'	; Display On, Cursor ON, Blink Block	 
DCU_ON			EQU  b'00001110'	; Display On, Cursor ON, Unterstrich	
Display_OFF		EQU  b'00001000'
SetFunction		EQU  b'00111000'	; 8 Bit, 2 Zeile, 5x8 Zeichen								
;Sreen/Cursor Shitf: b'0001-S/C-R/L-xx'
CursoeShiftR	EQU  b'00010100'	;S/C=1: DISPLAY SHIFT
CursoeShiftL	EQU  b'00010000'	;S/C=0 CURSOR MOVE
DisplayShiftR	EQU  b'00011100'	;R/L=1 SHIFT TO THE RIGHT
DisplayShiftL	EQU  b'00011000'	;R/L=0: SHIFT TO THE LEFT

RS_LCD			EQU	0x00	; RC0 pin 11 	; Select Read[1]/Write[0]
R_W_LCD			EQU	0x01	; RC1 pin 12	; H/L = Starts Read oder Write[1],Disable[0]
E_LCD			EQU	0x02	; RC2 pin 13	; Select Register RAM[1],Command[0]

;------------		Allgemeine definitionen		----------------------
ROM_STR_END		EQU		0x3A	; ASCII	Zeichen 3A=:
STR_Length		EQU		0x06

Key				EQU		0x00	; RA0 Pin 2, Taste mit Pullup
Key_Flag			EQU  H'0000'	; nicht verwendet

MAX_NUM_INT		EQU		0x02
Shadow			EQU		1
NoShadow		EQU		0

zahl_begin		EQU	0x05		; von zahl+1 bis zahl+4 wird gezeigt
zahl_ende		EQU	0x43
Aus_VN			EQU	H'0007'


